package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aRespuestaWS;

/**
 * Ab18aRespuestaWSDaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aRespuestaWSDaoImpl implements Ab18aRespuestaWSDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aRespuestaWS> rwMap = new RowMapper<Ab18aRespuestaWS>() {
		public Ab18aRespuestaWS mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aRespuestaWS(resultSet.getLong("T13IDINVOCACION"),
					resultSet.getLong("T13IDENVIOWS"),
					resultSet.getString("T13RESPUESTAWS"),
					resultSet.getDate("T13FECHARECEPWS"),
					resultSet.getString("T13ESTADOENVIOWS"),
					resultSet.getString("T13ERRORENVIOWS"),
					resultSet.getDate("T13FECHAMODIFENVIOWS"),
					resultSet.getString("T13CODENVIOWS"),
					resultSet.getLong("T01IDPETICIONENVIO"));
		}
	};

	private RowMapper<Ab18aRespuestaWS> rwMapPK = new RowMapper<Ab18aRespuestaWS>() {
		public Ab18aRespuestaWS mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aRespuestaWS(resultSet.getLong("T13IDINVOCACION"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aRespuestaWS>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aRespuestaWS>>() {
		public JerarquiaDto<Ab18aRespuestaWS> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			Ab18aRespuestaWS ab18a13s00 = new Ab18aRespuestaWS(
					resultSet.getLong("T13IDINVOCACION"),
					resultSet.getLong("T13IDENVIOWS"),
					resultSet.getString("T13RESPUESTAWS"),
					resultSet.getDate("T13FECHARECEPWS"),
					resultSet.getString("T13ESTADOENVIOWS"),
					resultSet.getString("T13ERRORENVIOWS"),
					resultSet.getDate("T13FECHAMODIFENVIOWS"),
					resultSet.getString("T13CODENVIOWS"),
					resultSet.getLong("T01IDPETICIONENVIO"));

			JerarquiaDto<Ab18aRespuestaWS> jerarquia = new JerarquiaDto<Ab18aRespuestaWS>();
			jerarquia.setModel(ab18a13s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a13s00 table.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @return Ab18aRespuestaWS
	 */
	public Ab18aRespuestaWS add(Ab18aRespuestaWS ab18a13s00) {
		String query = "INSERT INTO AB18A13S00 (T13_ID_INVOCACION, T01_ID_PETICION_ENVIO, T13_ID_ENVIO_WS, T13_RESPUESTA_WS, T13_FECHA_RECEP_WS, T13_ESTADO_ENVIO_WS, T13_ERROR_ENVIO_WS, T13_FECHA_MODIF_ENVIO_WS, T13_COD_ENVIO_WS) VALUES (?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, ab18a13s00.getT13IdInvocacion(),
				ab18a13s00.getT01IdPeticionEnvio(),
				ab18a13s00.getT13IdEnvioWs(), ab18a13s00.getT13RespuestaWs(),
				ab18a13s00.getT13FechaRecepWs(),
				ab18a13s00.getT13EstadoEnvioWs(),
				ab18a13s00.getT13ErrorEnvioWs(),
				ab18a13s00.getT13FechaModifEnvioWs(),
				ab18a13s00.getT13CodEnvioWs());
		return ab18a13s00;
	}

	/**
	 * Updates a single row in the Ab18a13s00 table.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @return Ab18aRespuestaWS
	 */
	public Ab18aRespuestaWS update(Ab18aRespuestaWS ab18a13s00) {
		String query = "UPDATE AB18A13S00 SET T01_ID_PETICION_ENVIO=?, T13_ID_ENVIO_WS=?, T13_RESPUESTA_WS=?, T13_FECHA_RECEP_WS=?, T13_ESTADO_ENVIO_WS=?, T13_ERROR_ENVIO_WS=?, T13_FECHA_MODIF_ENVIO_WS=?, T13_COD_ENVIO_WS=? WHERE T13_ID_INVOCACION=?";

		this.jdbcTemplate.update(query, ab18a13s00.getT01IdPeticionEnvio(),
				ab18a13s00.getT13IdEnvioWs(), ab18a13s00.getT13RespuestaWs(),
				ab18a13s00.getT13FechaRecepWs(),
				ab18a13s00.getT13EstadoEnvioWs(),
				ab18a13s00.getT13ErrorEnvioWs(),
				ab18a13s00.getT13FechaModifEnvioWs(),
				ab18a13s00.getT13CodEnvioWs(), ab18a13s00.getT13IdInvocacion());
		return ab18a13s00;
	}

	/**
	 * Finds a single row in the Ab18a13s00 table.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @return Ab18aRespuestaWS
	 */
	@Transactional(readOnly = true)
	public Ab18aRespuestaWS find(Ab18aRespuestaWS ab18a13s00) {
		String query = "SELECT t1.T13_ID_INVOCACION T13IDINVOCACION, t1.T13_ID_ENVIO_WS T13IDENVIOWS, t1.T13_RESPUESTA_WS T13RESPUESTAWS, t1.T13_FECHA_RECEP_WS T13FECHARECEPWS, t1.T13_ESTADO_ENVIO_WS T13ESTADOENVIOWS, t1.T13_ERROR_ENVIO_WS T13ERRORENVIOWS, t1.T13_FECHA_MODIF_ENVIO_WS T13FECHAMODIFENVIOWS, t1.T13_COD_ENVIO_WS T13CODENVIOWS, t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO, t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA, t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP, t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML, t2.T01_ID_PODER AB18A01S00T01IDPODER, t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP, t2.T01_ID_ORGANO AB18A01S00T01IDORGANO, t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM, t2.T01_ID_MESA AB18A01S00T01IDMESA, t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO, t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS, t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR, t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM, t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE, t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA, t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO, t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN, t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO, t2.T07_ID_TICKET AB18A01S00T07IDTICKET, t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION, t2.T11_ID_ESTADO AB18A01S00T11IDESTADO FROM AB18A13S00 t1 , AB18A01S00 t2  WHERE t1.T13_ID_INVOCACION = ?   AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+)";

		List<Ab18aRespuestaWS> ab18a13s00List = this.jdbcTemplate.query(query,
				this.rwMap, ab18a13s00.getT13IdInvocacion());
		return (Ab18aRespuestaWS) DataAccessUtils.uniqueResult(ab18a13s00List);
	}

	/**
	 * Removes a single row in the Ab18a13s00 table.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @return
	 */
	public void remove(Ab18aRespuestaWS ab18a13s00) {
		String query = "DELETE FROM AB18A13S00 WHERE T13_ID_INVOCACION=?";
		this.jdbcTemplate.update(query, ab18a13s00.getT13IdInvocacion());
	}

	/**
	 * Finds a list of rows in the Ab18a13s00 table.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18aRespuestaWS>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aRespuestaWS> findAll(Ab18aRespuestaWS ab18a13s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T13_ID_INVOCACION T13IDINVOCACION,t1.T13_ID_ENVIO_WS T13IDENVIOWS,t1.T13_RESPUESTA_WS T13RESPUESTAWS,t1.T13_FECHA_RECEP_WS T13FECHARECEPWS,t1.T13_ESTADO_ENVIO_WS T13ESTADOENVIOWS,t1.T13_ERROR_ENVIO_WS T13ERRORENVIOWS,t1.T13_FECHA_MODIF_ENVIO_WS T13FECHAMODIFENVIOWS,t1.T13_COD_ENVIO_WS T13CODENVIOWS,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		query.append("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a13s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aRespuestaWS>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a13s00 table using like.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18aRespuestaWS>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aRespuestaWS> findAllLike(Ab18aRespuestaWS ab18a13s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T13_ID_INVOCACION T13IDINVOCACION,t1.T13_ID_ENVIO_WS T13IDENVIOWS,t1.T13_RESPUESTA_WS T13RESPUESTAWS,t1.T13_FECHA_RECEP_WS T13FECHARECEPWS,t1.T13_ESTADO_ENVIO_WS T13ESTADOENVIOWS,t1.T13_ERROR_ENVIO_WS T13ERRORENVIOWS,t1.T13_FECHA_MODIF_ENVIO_WS T13FECHAMODIFENVIOWS,t1.T13_COD_ENVIO_WS T13CODENVIOWS,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		query.append("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a13s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aRespuestaWS>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a13s00 table.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aRespuestaWS ab18a13s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A13S00 t1 , AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a13s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab18a13s00 table using like.
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aRespuestaWS ab18a13s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A13S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a13s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a13s00 selected for rup_table
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18aRespuestaWS>>
	 */
	@Override
	public List<TableRowDto<Ab18aRespuestaWS>> reorderSelection(
			Ab18aRespuestaWS ab18a13s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T13_ID_INVOCACION T13IDINVOCACION,t1.T13_ID_ENVIO_WS T13IDENVIOWS,t1.T13_RESPUESTA_WS T13RESPUESTAWS,t1.T13_FECHA_RECEP_WS T13FECHARECEPWS,t1.T13_ESTADO_ENVIO_WS T13ESTADOENVIOWS,t1.T13_ERROR_ENVIO_WS T13ERRORENVIOWS,t1.T13_FECHA_MODIF_ENVIO_WS T13FECHAMODIFENVIOWS,t1.T13_COD_ENVIO_WS T13CODENVIOWS,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a13s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Ab18aRespuestaWS.class,
				filterParamList, "T13_ID_INVOCACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aRespuestaWS>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18aRespuestaWS
	 * @param searchParams
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18aRespuestaWS>>
	 */
	@Override
	public List<TableRowDto<Ab18aRespuestaWS>> search(
			Ab18aRespuestaWS filterParams, Ab18aRespuestaWS searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T13_ID_INVOCACION T13IDINVOCACION,t1.T13_ID_ENVIO_WS T13IDENVIOWS,t1.T13_RESPUESTA_WS T13RESPUESTAWS,t1.T13_FECHA_RECEP_WS T13FECHARECEPWS,t1.T13_ESTADO_ENVIO_WS T13ESTADOENVIOWS,t1.T13_ERROR_ENVIO_WS T13ERRORENVIOWS,t1.T13_FECHA_MODIF_ENVIO_WS T13FECHAMODIFENVIOWS,t1.T13_COD_ENVIO_WS T13CODENVIOWS,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Ab18aRespuestaWS.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"T13_ID_INVOCACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aRespuestaWS>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a13s00
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aRespuestaWS filterab18a13s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T13_ID_INVOCACION T13IDINVOCACION,t1.T13_ID_ENVIO_WS T13IDENVIOWS,t1.T13_RESPUESTA_WS T13RESPUESTAWS,t1.T13_FECHA_RECEP_WS T13FECHARECEPWS,t1.T13_ESTADO_ENVIO_WS T13ESTADOENVIOWS,t1.T13_ERROR_ENVIO_WS T13ERRORENVIOWS,t1.T13_FECHA_MODIF_ENVIO_WS T13FECHAMODIFENVIOWS,t1.T13_COD_ENVIO_WS T13CODENVIOWS,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a13s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						Ab18aRespuestaWS.class, query, params,
						"T13_ID_INVOCACION");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a13s00 table.
	 * 
	 * @param filterAb18aRespuestaWS
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18aRespuestaWS>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aRespuestaWS>> findAllLikeJerarquia(
			Ab18aRespuestaWS filterAb18aRespuestaWS,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T13_ID_INVOCACION T13IDINVOCACION,t1.T13_ID_ENVIO_WS T13IDENVIOWS,t1.T13_RESPUESTA_WS T13RESPUESTAWS,t1.T13_FECHA_RECEP_WS T13FECHARECEPWS,t1.T13_ESTADO_ENVIO_WS T13ESTADOENVIOWS,t1.T13_ERROR_ENVIO_WS T13ERRORENVIOWS,t1.T13_FECHA_MODIF_ENVIO_WS T13FECHAMODIFENVIOWS,t1.T13_COD_ENVIO_WS T13CODENVIOWS,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A13S00");
		from.add("AB18A01S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18aRespuestaWS,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "T13_ID_INVOCACION", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18aRespuestaWS
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(
			Ab18aRespuestaWS filterAb18aRespuestaWS,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A13S00");
		from.add("AB18A01S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18aRespuestaWS,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "T13_ID_INVOCACION", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18aRespuestaWS
	 *            Ab18aRespuestaWS
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18aRespuestaWS>>
	 */
	@Override
	public List<TableRowDto<Ab18aRespuestaWS>> findAllChild(
			Ab18aRespuestaWS filterAb18aRespuestaWS,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A13S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A13S00");
		from.add("AB18A01S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18aRespuestaWS,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "T13_ID_INVOCACION", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Ab18aRespuestaWS>(this.rwMapPK,
						"T13_ID_INVOCACION"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a13s00 entity
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aRespuestaWS ab18a13s00) {

		StringBuilder where = new StringBuilder(
				Ab18aRespuestaWSDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a13s00 != null && ab18a13s00.getT13IdInvocacion() != null) {
			where.append(" AND t1.T13_ID_INVOCACION = ?");
			params.add(ab18a13s00.getT13IdInvocacion());
		}
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdPeticionEnvio() != null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdPeticionEnvio());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a06s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a06s00().getT06IdBoletin() !=
		// null) {
		// where.append(" AND t2.T06_ID_BOLETIN = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a06s00()
		// .getT06IdBoletin());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a02s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio() != null) {
		// where.append(" AND t2.T02_ID_TIPO_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a07s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a07s00().getT07IdTicket() !=
		// null) {
		// where.append(" AND t2.T07_ID_TICKET = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a07s00()
		// .getT07IdTicket());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a03s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t2.T03_ID_APLICACION = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a11s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a11s00().getT11IdEstado() !=
		// null) {
		// where.append(" AND t2.T11_ID_ESTADO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a11s00()
		// .getT11IdEstado());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01FechaAlta() != null) {
		// where.append(" AND t2.T01_FECHA_ALTA = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01FechaAlta());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdPoder() != null) {
		// where.append(" AND t2.T01_ID_PODER = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdPoder());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdEntidadImp() != null) {
		// where.append(" AND t2.T01_ID_ENTIDAD_IMP = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdEntidadImp());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdOrgano() != null) {
		// where.append(" AND t2.T01_ID_ORGANO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdOrgano());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdEntidadTram() != null) {
		// where.append(" AND t2.T01_ID_ENTIDAD_TRAM = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdEntidadTram());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdMesa() != null) {
		// where.append(" AND t2.T01_ID_MESA = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdMesa());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01FechaProgrEnvio() != null) {
		// where.append(" AND t2.T01_FECHA_PROGR_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01FechaProgrEnvio());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01NumIntentos() != null) {
		// where.append(" AND t2.T01_NUM_INTENTOS = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01NumIntentos());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01DatosError() != null) {
		// where.append(" AND t2.T01_DATOS_ERROR = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01DatosError());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01EstadoTram() != null) {
		// where.append(" AND t2.T01_ESTADO_TRAM = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01EstadoTram());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01CodExpediente() != null) {
		// where.append(" AND t2.T01_COD_EXPEDIENTE = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01CodExpediente());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a14s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio() != null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio());
		// }
		if (ab18a13s00 != null && ab18a13s00.getT13IdEnvioWs() != null) {
			where.append(" AND t1.T13_ID_ENVIO_WS = ?");
			params.add(ab18a13s00.getT13IdEnvioWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13RespuestaWs() != null) {
			where.append(" AND t1.T13_RESPUESTA_WS = ?");
			params.add(ab18a13s00.getT13RespuestaWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13FechaRecepWs() != null) {
			where.append(" AND t1.T13_FECHA_RECEP_WS = ?");
			params.add(ab18a13s00.getT13FechaRecepWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13EstadoEnvioWs() != null) {
			where.append(" AND t1.T13_ESTADO_ENVIO_WS = ?");
			params.add(ab18a13s00.getT13EstadoEnvioWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13ErrorEnvioWs() != null) {
			where.append(" AND t1.T13_ERROR_ENVIO_WS = ?");
			params.add(ab18a13s00.getT13ErrorEnvioWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13FechaModifEnvioWs() != null) {
			where.append(" AND t1.T13_FECHA_MODIF_ENVIO_WS = ?");
			params.add(ab18a13s00.getT13FechaModifEnvioWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13CodEnvioWs() != null) {
			where.append(" AND t1.T13_COD_ENVIO_WS = ?");
			params.add(ab18a13s00.getT13CodEnvioWs());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a13s00 entity
	 * 
	 * @param ab18a13s00
	 *            Ab18aRespuestaWS Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aRespuestaWS ab18a13s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Ab18aRespuestaWSDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a13s00 != null && ab18a13s00.getT13IdInvocacion() != null) {
			where.append(" AND t1.T13_ID_INVOCACION = ?");
			params.add(ab18a13s00.getT13IdInvocacion());
		}
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdPeticionEnvio() != null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdPeticionEnvio());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a06s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a06s00().getT06IdBoletin() !=
		// null) {
		// where.append(" AND t2.T06_ID_BOLETIN = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a06s00()
		// .getT06IdBoletin());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a02s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio() != null) {
		// where.append(" AND t2.T02_ID_TIPO_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a07s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a07s00().getT07IdTicket() !=
		// null) {
		// where.append(" AND t2.T07_ID_TICKET = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a07s00()
		// .getT07IdTicket());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a03s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t2.T03_ID_APLICACION = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a11s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a11s00().getT11IdEstado() !=
		// null) {
		// where.append(" AND t2.T11_ID_ESTADO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a11s00()
		// .getT11IdEstado());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01FechaAlta() != null) {
		// where.append(" AND t2.T01_FECHA_ALTA = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01FechaAlta());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdPoder() != null) {
		// where.append(" AND t2.T01_ID_PODER = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdPoder());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdEntidadImp() != null) {
		// where.append(" AND t2.T01_ID_ENTIDAD_IMP = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdEntidadImp());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdOrgano() != null) {
		// where.append(" AND t2.T01_ID_ORGANO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdOrgano());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdEntidadTram() != null) {
		// where.append(" AND t2.T01_ID_ENTIDAD_TRAM = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdEntidadTram());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01IdMesa() != null) {
		// where.append(" AND t2.T01_ID_MESA = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01IdMesa());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01FechaProgrEnvio() != null) {
		// where.append(" AND t2.T01_FECHA_PROGR_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01FechaProgrEnvio());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01NumIntentos() != null) {
		// where.append(" AND t2.T01_NUM_INTENTOS = ?");
		// params.add(ab18a13s00.getAb18a01s00().getT01NumIntentos());
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01DatosError() != null) {
		// where.append(" AND UPPER(t2.T01_DATOS_ERROR) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a13s00.getAb18a01s00().getT01DatosError()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a13s00.getAb18a01s00().getT01DatosError()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T01_DATOS_ERROR IS NOT NULL");
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01EstadoTram() != null) {
		// where.append(" AND UPPER(t2.T01_ESTADO_TRAM) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a13s00.getAb18a01s00().getT01EstadoTram()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a13s00.getAb18a01s00().getT01EstadoTram()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T01_ESTADO_TRAM IS NOT NULL");
		// }
		// if (ab18a13s00 != null && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getT01CodExpediente() != null) {
		// where.append(" AND UPPER(t2.T01_COD_EXPEDIENTE) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a13s00.getAb18a01s00().getT01CodExpediente()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a13s00.getAb18a01s00().getT01CodExpediente()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T01_COD_EXPEDIENTE IS NOT NULL");
		// }
		// if (ab18a13s00 != null
		// && ab18a13s00.getAb18a01s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a14s00() != null
		// && ab18a13s00.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio() != null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a13s00.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio());
		// }
		if (ab18a13s00 != null && ab18a13s00.getT13IdEnvioWs() != null) {
			where.append(" AND t1.T13_ID_ENVIO_WS = ?");
			params.add(ab18a13s00.getT13IdEnvioWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13RespuestaWs() != null) {
			where.append(" AND UPPER(t1.T13_RESPUESTA_WS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a13s00.getT13RespuestaWs().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a13s00.getT13RespuestaWs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T13_RESPUESTA_WS IS NOT NULL");
		}
		if (ab18a13s00 != null && ab18a13s00.getT13FechaRecepWs() != null) {
			where.append(" AND t1.T13_FECHA_RECEP_WS = ?");
			params.add(ab18a13s00.getT13FechaRecepWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13EstadoEnvioWs() != null) {
			where.append(" AND UPPER(t1.T13_ESTADO_ENVIO_WS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a13s00.getT13EstadoEnvioWs().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a13s00.getT13EstadoEnvioWs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T13_ESTADO_ENVIO_WS IS NOT NULL");
		}
		if (ab18a13s00 != null && ab18a13s00.getT13ErrorEnvioWs() != null) {
			where.append(" AND UPPER(t1.T13_ERROR_ENVIO_WS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a13s00.getT13ErrorEnvioWs().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a13s00.getT13ErrorEnvioWs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T13_ERROR_ENVIO_WS IS NOT NULL");
		}
		if (ab18a13s00 != null && ab18a13s00.getT13FechaModifEnvioWs() != null) {
			where.append(" AND t1.T13_FECHA_MODIF_ENVIO_WS = ?");
			params.add(ab18a13s00.getT13FechaModifEnvioWs());
		}
		if (ab18a13s00 != null && ab18a13s00.getT13CodEnvioWs() != null) {
			where.append(" AND UPPER(t1.T13_COD_ENVIO_WS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a13s00.getT13CodEnvioWs().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a13s00.getT13CodEnvioWs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T13_COD_ENVIO_WS IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
